//-------------------------------------------------------------------------------------
// SID Monitor - Utility for Sudden Ionospheric Disturbances Monitoring Stations
// Copyright (C) 2005 - Lionel Loudet
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//-------------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;


namespace SID_monitor
{
    public partial class PanelReports : UserControl
    {
        public PanelReports()
        {
            InitializeComponent();

            // set values according to settings
            this.checkBoxSendMail.Checked = SID_monitor.Properties.Settings.Default.SendMailUponEventDetection;
            this.radioButtonHourlyCheck.Checked = SID_monitor.Properties.Settings.Default.SendMailHourly;
            this.radioButtonDailyCheck.Checked = !SID_monitor.Properties.Settings.Default.SendMailHourly;
            this.checkBoxAttachGraph.Checked = SID_monitor.Properties.Settings.Default.SendMailWithGraph;
            this.textBoxSendMailTo.Text = SID_monitor.Properties.Settings.Default.SendMailTo;
            this.textBoxSendMailFrom.Text = SID_monitor.Properties.Settings.Default.SendMailFrom;
            this.textBoxSMTPServerAddress.Text = SID_monitor.Properties.Settings.Default.SMTPServerAddress;
            this.numericUpDownSMTPServerPort.Value = SID_monitor.Properties.Settings.Default.SMTPServerPort;

            this.maskedTextBoxObserverCode.Text = SID_monitor.Properties.Settings.Default.ObserverCode;

            // enables or disables some items
            this.radioButtonHourlyCheck.Enabled = this.checkBoxSendMail.Checked;
            this.radioButtonDailyCheck.Enabled = this.checkBoxSendMail.Checked;
            this.checkBoxAttachGraph.Enabled = this.checkBoxSendMail.Checked;
            this.textBoxSendMailTo.Enabled = this.checkBoxSendMail.Checked;
            this.textBoxSendMailFrom.Enabled = this.checkBoxSendMail.Checked;
            this.textBoxSMTPServerAddress.Enabled = this.checkBoxSendMail.Checked;
            this.numericUpDownSMTPServerPort.Enabled = this.checkBoxSendMail.Checked;
            this.labelSendMailTo.Enabled = this.checkBoxSendMail.Checked;
            this.labelSendMailFrom.Enabled = this.checkBoxSendMail.Checked;
            this.labelSMTPServerAddress.Enabled = this.checkBoxSendMail.Checked;
            this.labelSMTPServerPort.Enabled = this.checkBoxSendMail.Checked;
        }


        private void checkBoxSendMail_CheckedChanged(object sender, EventArgs e)
        {
            this.radioButtonHourlyCheck.Enabled = this.checkBoxSendMail.Checked;
            this.radioButtonDailyCheck.Enabled = this.checkBoxSendMail.Checked;
            this.checkBoxAttachGraph.Enabled = this.checkBoxSendMail.Checked;
            this.textBoxSendMailTo.Enabled = this.checkBoxSendMail.Checked;
            this.textBoxSendMailFrom.Enabled = this.checkBoxSendMail.Checked;
            this.textBoxSMTPServerAddress.Enabled = this.checkBoxSendMail.Checked;
            this.numericUpDownSMTPServerPort.Enabled = this.checkBoxSendMail.Checked;
            this.labelSendMailTo.Enabled = this.checkBoxSendMail.Checked;
            this.labelSendMailFrom.Enabled = this.checkBoxSendMail.Checked;
            this.labelSMTPServerAddress.Enabled = this.checkBoxSendMail.Checked;
            this.labelSMTPServerPort.Enabled = this.checkBoxSendMail.Checked;
        }


        #region Properties
        public bool SendMailUponEventDetection
        {
            get
            {
                return this.checkBoxSendMail.Checked;
            }
        }

        public bool SendMailHourly
        {
            get
            {
                return this.radioButtonHourlyCheck.Checked;
            }
        }

        public bool SendMailWithGraph
        {
            get
            {
                return this.checkBoxAttachGraph.Checked;
            }
        }

        public string SendMailTo
        {
            get
            {
                return this.textBoxSendMailTo.Text;
            }
        }

        public string SendMailFrom
        {
            get
            {
                return this.textBoxSendMailFrom.Text;
            }
        }

        public string SMTPServerAddress
        {
            get
            {
                return this.textBoxSMTPServerAddress.Text;
            }
        }

        public int SMTPServerPort
        {
            get
            {
                return Convert.ToInt32(this.numericUpDownSMTPServerPort.Value);
            }
        }

        public string ObserverCode
        {
            get
            {
                return this.maskedTextBoxObserverCode.Text;
            }
        }
        #endregion

        #region Values Validation Method
        private void textBoxSendMail_TextChanged(object sender, EventArgs e)
        {
            TextBox currentTextBox = (TextBox)sender;
            if ( currentTextBox.Enabled && !Regex.IsMatch(currentTextBox.Text, @"^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$") )
            {
                errorProvider.SetError(currentTextBox, "Please enter a valid email address");
                OnValidData(new validDataEventArgs("NodeReports", currentTextBox.Handle, false));
            }
            else
            {
                errorProvider.SetError(currentTextBox, "");
                OnValidData(new validDataEventArgs("NodeReports", currentTextBox.Handle, true));
            }
        }
        
        private void textBoxSMTP_TextChanged(object sender, EventArgs e)
        {
            TextBox currentTextBox = (TextBox)sender;
            if ( currentTextBox.Enabled && !Regex.IsMatch(currentTextBox.Text, @"^((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$") )
            {
                errorProvider.SetError(currentTextBox, "Please enter a valid email server name or IP address");
                OnValidData(new validDataEventArgs("NodeReports", currentTextBox.Handle, false));
            }
            else
            {
                errorProvider.SetError(currentTextBox, "");
                OnValidData(new validDataEventArgs("NodeReports", currentTextBox.Handle, true));
            }
        }

        private void maskedTextBoxObserverCode_TextChanged(object sender, EventArgs e)
        {
            if ( maskedTextBoxObserverCode.MaskFull )
            {
                errorProvider.SetError(maskedTextBoxObserverCode, "");
                OnValidData(new validDataEventArgs("NodeReports", maskedTextBoxObserverCode.Handle, true));
            }
            else
            {
                errorProvider.SetError(maskedTextBoxObserverCode, "Invalid Observer Code Format. Observer code consists of 4 alphanumeric characters.");
                OnValidData(new validDataEventArgs("NodeReports", maskedTextBoxObserverCode.Handle, false));
            }
        }

        #endregion

        #region ValidData Event
        public event ValidDataEventHandler ValidData;

        protected virtual void OnValidData(validDataEventArgs e)
        {
            if ( ValidData != null )
            {
                // Invokes the delegates. 
                ValidData(this, e);
            }
        }
        #endregion


            


    }
}
